<?php
	
function your_scripts() {
$deps = $ver = "";
  wp_enqueue_script( 'script-name', get_template_directory_uri() . '/functions/js/ajax.js', $deps, $ver, true);
  wp_localize_script( 'script-name', 'MyAjax', array(
    // URL to wp-admin/admin-ajax.php to process data
    'ajaxurl' => admin_url( 'admin-ajax.php' ),
 
    // Creates a random string to test against for security purposes
    'security' => wp_create_nonce( 'my-special-string' )
  ));
}
add_action( 'wp_enqueue_scripts', 'your_scripts' );



function contact_ajax(){
	wp_verify_nonce( 'my-special-string', 'security' );
	$fname = htmlspecialchars(stripslashes(trim($_POST['fname'])));
	$email = htmlspecialchars(stripslashes(trim($_POST['email'])));
	$phone = htmlspecialchars(stripslashes(trim($_POST['phone'])));
	$message = htmlspecialchars(stripslashes(trim($_POST['message'])));
	$more_info = htmlspecialchars(stripslashes(trim($_POST['more_info'])));
	$cost_calculator_email = htmlspecialchars(stripslashes(trim($_POST['cost_calculator_email'])));
	$cost = htmlspecialchars(stripslashes(trim($_POST['cost'])));
	
	$errors = array();
	if(strlen($fname) < 4){
		$errors[] = "Please Enter Your Full Name";
	}
	if(filter_var($email, FILTER_VALIDATE_EMAIL)) {
	
	} else {
		$errors[] = "Please Enter A Valid Email";
	}
	
	if($errors){
		$error_encode = "<div class='form_errors'>";
		foreach($errors as $error){
			$error_encode .= "$error<br/>";
		}
		$error_encode .= "</div>";
		echo json_encode("$error_encode");
		die();
	} else {
 
		
		$email_message  = "<strong>Name:</strong> $fname <br />";
		$email_message .= "<strong>Email:</strong> $email <br />";
		$email_message .= "<strong>Phone:</strong> $phone <br />";
		$email_message .= "<strong>Message:</strong> $message <br />";
		
		$email_message .= "<strong>Approximate Project Cost:</strong> $cost.00$";
 
 
		$mail_send = wp_mail( $cost_calculator_email, 'Your Web Contact Form', $email_message, 'no-reply@yourdomain.com' );
		
 
		if($mail_send){
			echo json_encode("<div class='form_success'>Success! You Will Hear From Us Shortly</div><script>jQuery('#contact')[0].reset();</script>");
			die();
		}
	}
	
	
}
 
add_action( 'wp_ajax_contact_ajax', 'contact_ajax' );
add_action( 'wp_ajax_nopriv_contact_ajax', 'contact_ajax' );

function wpse27856_set_content_type(){
    return "text/html";
}
add_filter( 'wp_mail_content_type','wpse27856_set_content_type' );

?>