<?php   
    /* 
    Plugin Name: MadzaBuilder
    Plugin URI: http://www.madzathemes.com 
    Description: MadzaTheme Plugin 
    Author: Madars Bitenieks 
    Version: 1.2
    Author URI: http://www.madzathemes.com 
    */  
  
include_once ('shortcodes.php');
include_once ('cost-calsuclator-form.php');
/*
|--------------------------------------------------------------------------
| CONSTANTS
|--------------------------------------------------------------------------
*/

if( !defined( 'RC_TC_BASE_FILE' ) )		define( 'RC_TC_BASE_FILE', __FILE__ );
if( !defined( 'RC_TC_BASE_DIR' ) ) 		define( 'RC_TC_BASE_DIR', dirname( RC_TC_BASE_FILE ) );
if( !defined( 'RC_TC_PLUGIN_URL' ) ) 	define( 'RC_TC_PLUGIN_URL', plugin_dir_url( __FILE__ ) );



/* Author: Madars Bitenieks */

/*----------------------------------*/
$mt_o = get_option("themename_theme_options");

if(!empty($mt_o['mt_rewrite_doctor'])) { $mt_cpt_doctor = $mt_o['mt_rewrite_doctor']; } else { $mt_cpt_doctor = "our-staff";}  
if(!empty($mt_o['mt_rewrite_services'])) { $mt_cpt_services = $mt_o['mt_rewrite_services']; } else { $mt_cpt_services = "our-services";}  
if(!empty($mt_o['mt_rewrite_causes'])) { $mt_cpt_causes = $mt_o['mt_rewrite_causes']; } else { $mt_cpt_causes = "our-causes";}  
if(!empty($mt_o['mt_rewrite_portfolio'])) { $mt_cpt_portfolio = $mt_o['mt_rewrite_portfolio']; } else { $mt_cpt_portfolio = "portfolio";} 

$mt_cpt_sections = "mt_section";

/*----------------------------------*/

$l1 = '/images/patterns/';
$l2 = get_template_directory_uri().'/images/patterns/';

$patterns = array(
	array(
		'value'   => 'off',
		'label'   => 'none',
		'src'     => get_template_directory_uri().'/images/patterns/patterns-none.jpg'
	),
	array( 	'value' => $l1.'60degree_gray.png', 'label' => '60degree_gray', 'src' => $l2.'60degree_gray.png' ),
	array( 	'value' => $l1.'agsquare.png', 'label' => 'agsquare', 'src' => $l2.'agsquare.png' ),
	array( 	'value' => $l1.'back_pattern.png', 'label' => 'back_pattern', 'src' => $l2.'back_pattern.png' ),
	
	
	array(
		'value'   => '/images/patterns/brickwall.png',
		'label'   => 'brickwall',
		'src'     => get_template_directory_uri().'/images/patterns/brickwall.png'
	),
	array(
		'value'   => '/images/patterns/escheresque_ste.png',
		'label'   => 'escheresque_ste',
		'src'     => get_template_directory_uri().'/images/patterns/escheresque_ste.png'
	),

	array(
		'value'   => '/images/patterns/skelatal_weave.png',
		'label'   => 'brickwall',
		'src'     => get_template_directory_uri().'/images/patterns/skelatal_weave.png'
	),
	array(
		'value'   => '/images/patterns/greyfloral.png',
		'label'   => 'greyfloral',
		'src'     => get_template_directory_uri().'/images/patterns/greyfloral.png'
	)    
);							      
						      

/*-----------------------------------------------------------------------------------*/
/*	EVENT Services Post  -----------------------------------------------------------*/
/*---------------------------------------------------------------------------------*/

function madza_services() {
global $mt_cpt_services;
  $labels = array(
    'name' => esc_html_x('Services', 'post type general name', 'madza_builder69'),
    'singular_name' => esc_html_x('Services', 'post type singular name', 'madza_builder69'),
    'add_new' => esc_html_x('Add Service', 'Partner Item', 'madza_builder69'),
    'add_new_item' => esc_html__('Add New Service', 'madza_builder69'),
    'edit_item' => esc_html__('Edit Service', 'madza_builder69'),
    'new_item' => esc_html__('New Service', 'madza_builder69'),
    'view_item' => esc_html__('View Service Details', 'madza_builder69'),
    'search_items' => esc_html__('Search Service', 'madza_builder69'),
    'not_found' =>  esc_html__('No Service were found with that criteria', 'madza_builder69'),
    'not_found_in_trash' => esc_html__('No Service found in the Trash with that criteria', 'madza_builder69'),
    'view' =>  esc_html__('View Service', 'madza_builder69')   
  );

  $args = array(
    'labels' => $labels,
    'label' => esc_html__('Service', 'madza_builder69'),
    'singular_label' => esc_html__('Service', 'madza_builder69'),
    'public' => true,
    'show_ui' => true,
    '_builtin' => false,
    'capability_type' => 'post',
    'exclude_from_search' => true,
    'hierarchical' => true,
    'rewrite' => array('slug' => $mt_cpt_services),
    'menu_position' => 30,
    'menu_icon' => get_template_directory_uri().'/images/mt_icon_partner.png',
    'supports' => array('title', 'editor','thumbnail', 'revisions')
  );

  register_post_type('our-services',$args);

$labels = array(
  'name' => esc_html__('Categories', 'madza_builder69'),
  'singular_name' => esc_html__('Categories', 'madza_builder69'),
  'search_items' =>  esc_html__('Search', 'madza_builder69'),
  'popular_items' => esc_html__('Popular things', 'madza_builder69'),
  'all_items' => esc_html__( 'Everything' , 'madza_builder69'),
  'parent_item' => esc_html__( 'Parent Categories', 'madza_builder69' ),
  'parent_item_colon' => esc_html__( 'Parent Categories:' , 'madza_builder69'),
  'edit_item' => esc_html__( 'Edit' , 'madza_builder69'),
  'update_item' => esc_html__( 'Update' , 'madza_builder69'),
  'add_new_item' => esc_html__( 'Add New' , 'madza_builder69'),
  'new_item_name' => esc_html__( 'New Name' , 'madza_builder69')
);


register_taxonomy($mt_cpt_services.'_cat', array('our-services'),
	array(
	'hierarchical' => true,
	'labels' => $labels,
	'show_ui' => true,
	'query_var' => true,
	'rewrite' => array('slug' => 'service_categories')
));


}
add_action('init', 'madza_services');



add_action( 'admin_init', 'mt_service_metabox' );

function mt_service_metabox() {

  $mt_service_metabox = array(
    'id'        => 'mt_services_metabox',
    'title'     => 'Service Item Options',
    'desc'      => '',
    'pages' => array('our-services'),
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
     	array(
     	'id'          => 'mt_short_text',
        'label'       => 'Short Text',
        'std'         => '',
        'type'        => 'text',
        'class'       => '',
        'choices'     => array()
         ), 
		 array(
        'id'          => 'mt_icon',
        'label'       => 'Icon',
        'std'         => '',
        'type'        => 'text',
        'class'       => '',
        'choices'     => array()
         ),   
         
         array(
        'id'          => 'mt_portfolio_slider_height',
        'label'       => 'Slider Height (px)',
        'desc'        => '',
        'std'         => '230',
        'type'        => 'numeric_slider',
        'min_max_step'=> '100,1000,10',
          )
        ,
        
      array(
        'id'          => 'layout_sidebar',
        'label'       => 'Sidebar',
        'desc'        => '',
        'std'         => '',
         'post_type'   => 'mt_sidebar',
        'type'        => 'sidebar-select',
        'class'       => '',
        'choices'     => array(
					        array(
					        'value'   => 'sidebar_off',
					        'label'   => esc_html__( 'Sidebar Off', 'madza_builder69' )
					      )
        )
      ),
      array(
        'id'          => 'mb_page_sections_in',
        'label'       => 'Page Sections',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'section',
            'label'   => 'Page Section',
            'desc'    => '',
            'std'     => '',
            'type'        => 'custom-post-type-select',
            'post_type'   => 'mt_section',
            'class'   => '',
            'choices' => array()
          )
        )
        ),

		

)
    
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $mt_service_metabox ); }

}



function mt_section() {
global $mt_cpt_sections;
  $labels = array(
    'name' => esc_html_x('Page Sections', 'post type general name', 'madza_builder69'),
    'singular_name' => esc_html_x('Page Section', 'post type singular name', 'madza_builder69'),
    'add_new' => esc_html_x('Add Page Section', 'Events Item', 'madza_builder69'),
    'add_new_item' => esc_html__('Add New Page Section', 'madza_builder69'),
    'edit_item' => esc_html__('Edit Page Section', 'madza_builder69'),
    'new_item' => esc_html__('New Page Section', 'madza_builder69'),
    'view_item' => esc_html__('View Page Section Details', 'madza_builder69'),
    'search_items' => esc_html__('Search Page Section', 'madza_builder69'),
    'not_found' =>  esc_html__('No Page Section were found with that criteria', 'madza_builder69'),
    'not_found_in_trash' => esc_html__('No Page Section found in the Trash with that criteria', 'madza_builder69'),
    'view' =>  esc_html__('View Page Section', 'madza_builder69')   
  );

  $args = array(
    'labels' => $labels,
    'label' => esc_html__('Page Sections', 'madza_builder69'),
    'singular_label' => esc_html__('Page Section', 'madza_builder69'),
    'public' => true,
    'show_ui' => true,
    '_builtin' => false,
    'capability_type' => 'page',
    'exclude_from_search' => true,
    'hierarchical' => true,
    'rewrite' => array('slug' => $mt_cpt_sections),
    'menu_position' => 30,
    'menu_icon' => get_template_directory_uri().'/images/mt_icon_event.png',
    'supports' => array('title', 'editor', 'revisions')
  );

  register_post_type('mt_section',$args);
}
add_action('init', 'mt_section');




add_action( 'admin_init', 'mt_section_metabox' );

function mt_section_metabox() {
global $patterns;
  $mt_section_metabox = array(
    'id'        => 'mt_section_metabox',
    'title'     => 'Options',
    'desc'      => '',
    'pages' => 'mt_section',
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
    
  
	     array(
		        'id'          => 'mt_in_all_pages',
		        'label'       => 'Show in all pages',
		        'desc'        => '',
		        'std'         => 'no',
		        'type'        => 'select',
		        'class'       => '',
		        'choices'     => array( 
				        array(
				        'value'   => 'no',
				        'label'   => esc_html__( 'Off', 'madza_builder69' )
				      ),
				      array(
				        'value'   => 'yes',
				        'label'   => esc_html__( 'On', 'madza_builder69' )
				      ))
	      ),     
	      array(
	        'id'          => 'mt_section_background',
	        'label'       => 'Section Background',
	        'desc'        => '',
	        'std'         => '',
	        'type'        => 'background',
	        'class'       => '',
	        'choices'     => array()
	      ), 
		
        
     )
    
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $mt_section_metabox); }

}


/*-----------------------------------------------------------------------------------*/
/*	EVENT Staff Post  -------------------------------------------------------------*/
/*---------------------------------------------------------------------------------*/

function madza_staff() {
global $mt_cpt_doctor;
  $labels = array(
    'name' => esc_html_x('Our Staff', 'post type general name', 'madza_builder69'),
    'singular_name' => esc_html_x('Staff', 'post type singular name', 'madza_builder69'),
    'add_new' => esc_html_x('Add Staff', 'Staff Item', 'madza_builder69'),
    'add_new_item' => esc_html__('Add New Staff', 'madza_builder69'),
    'edit_item' => esc_html__('Edit Staff', 'madza_builder69'),
    'new_item' => esc_html__('New Staff', 'madza_builder69'),
    'view_item' => esc_html__('View Staff Details', 'madza_builder69'),
    'search_items' => esc_html__('Search Staff', 'madza_builder69'),
    'not_found' =>  esc_html__('No Staff were found with that criteria', 'madza_builder69'),
    'not_found_in_trash' => esc_html__('No Staff found in the Trash with that criteria', 'madza_builder69'),
    'view' =>  esc_html__('View Staff', 'madza_builder69')   
  );

  $args = array(
    'labels' => $labels,
    'label' => esc_html__('Staff', 'madza_builder69'),
    'singular_label' => esc_html__('Staff', 'madza_builder69'),
    'public' => true,
    'show_ui' => true,
    '_builtin' => false,
    'capability_type' => 'page',
    'exclude_from_search' => true,
    'hierarchical' => true,
    'rewrite' => array('slug' => $mt_cpt_doctor),
    'menu_position' => 30,
    'menu_icon' => get_template_directory_uri().'/images/mt_icon_staff.png',
    'supports' => array('title', 'editor','thumbnail', 'revisions')
  );

  register_post_type('our-staff',$args);



$labels = array(
  'name' => esc_html__('Categories', 'madza_builder69'),
  'singular_name' => esc_html__('Categories', 'madza_builder69'),
  'search_items' =>  esc_html__('Search', 'madza_builder69'),
  'popular_items' => esc_html__('Popular things', 'madza_builder69'),
  'all_items' => esc_html__( 'Everything' , 'madza_builder69'),
  'parent_item' => esc_html__( 'Parent Categories', 'madza_builder69' ),
  'parent_item_colon' => esc_html__( 'Parent Categories:' , 'madza_builder69'),
  'edit_item' => esc_html__( 'Edit' , 'madza_builder69'),
  'update_item' => esc_html__( 'Update' , 'madza_builder69'),
  'add_new_item' => esc_html__( 'Add New' , 'madza_builder69'),
  'new_item_name' => esc_html__( 'New Name' , 'madza_builder69')
);


register_taxonomy($mt_cpt_doctor.'_cat', array('our-staff'),
	array(
	'hierarchical' => true,
	'labels' => $labels,
	'show_ui' => true,
	'query_var' => true,
	'rewrite' => array('slug' => 'doctor_categories')
));

}
add_action('init', 'madza_staff');


add_action( 'admin_init', 'mt_staff_metabox' );

function mt_staff_metabox() {

  $mt_staff_metabox = array(
    'id'        => 'mt_staff_metabox',
    'title'     => 'Staff Item Options',
    'desc'      => '',
    'pages' => array('our-staff'),
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
     	array(
	        'id'          => 'mt_doctor_education',
	        'label'       => 'Staff Education',
	        'std'         => '',
	        'type'        => 'text',
	        'class'       => '',
	        'choices'     => array()
         ),
         array(
	        'id'          => 'mt_doctor_twitter',
	        'label'       => 'Staff Twitter',
	        'std'         => '',
	        'type'        => 'text',
	        'class'       => '',
	        'choices'     => array()
         ),
         array(
	        'id'          => 'mt_doctor_facebook',
	        'label'       => 'Staff Facebook',
	        'std'         => '',
	        'type'        => 'text',
	        'class'       => '',
	        'choices'     => array()
         ),
         array(
	        'id'          => 'mt_doctor_google',
	        'label'       => 'Staff Google Plus',
	        'std'         => '',
	        'type'        => 'text',
	        'class'       => '',
	        'choices'     => array()
         ), 
         array(
	        'id'          => 'mt_doctor_linked',
	        'label'       => 'Staff LinkedIn',
	        'std'         => '',
	        'type'        => 'text',
	        'class'       => '',
	        'choices'     => array()
         ), 


             
          array(
        'id'          => 'mt_portfolio_slider_height',
        'label'       => 'Image Height (px)',
        'desc'        => '',
        'std'         => '400',
        'type'        => 'numeric_slider',
        'min_max_step'=> '100,1000,10',
        'class'       => '',
        'choices'     => array()
          )
        , 
     
      array(
        'id'          => 'mb_page_sections_in',
        'label'       => 'Page Sections',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'section',
            'label'   => 'Page Section',
            'desc'    => '',
            'std'     => '',
            'type'        => 'custom-post-type-select',
            'post_type'   => 'mt_section',
            'class'   => '',
            'choices' => array()
          )
        )
        ),

		

)
    
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $mt_staff_metabox ); }

}




/*-----------------------------------------------------------------------------------*/
/*	SIDEBAR Custom Post ------------------------------------------------------------*/
/*---------------------------------------------------------------------------------*/

function madza_sidebar() {
  $labels = array(
    'name' => esc_html_x('Sidebars', 'post type general name', 'madza_builder69'),
    'singular_name' => esc_html_x('Sidebar', 'post type singular name', 'madza_builder69'),
    'add_new' => esc_html_x('Add Sidebar', 'Event Item', 'madza_builder69'),
    'add_new_item' => esc_html__('Add New Sidebar', 'madza_builder69'),
    'edit_item' => esc_html__('Edit Sidebar', 'madza_builder69'),
    'new_item' => esc_html__('New Sidebar', 'madza_builder69'),
    'view_item' => esc_html__('View Sidebar Details', 'madza_builder69'),
    'search_items' => esc_html__('Search Sidebar', 'madza_builder69'),
    'not_found' =>  esc_html__('No sidebar were found with that criteria', 'madza_builder69'),
    'not_found_in_trash' => esc_html__('No sidebar found in the Trash with that criteria', 'madza_builder69'),
    'view' =>  esc_html__('View Item', 'madza_builder69')   
  );

  $args = array(
    'labels' => $labels,
    'label' => esc_html__('Sidebars', 'madza_builder69'),
    'singular_label' => esc_html__('Sidebar', 'madza_builder69'),
    'public' => true,
    'show_ui' => true,
    '_builtin' => false,
    'capability_type' => 'page',
    'exclude_from_search' => true,
    'hierarchical' => true,
    'rewrite' => true,
    'menu_position' => 30,
    'menu_icon' => get_template_directory_uri().'/images/layout_select_sidebar_icon.png',
    'supports' => array('title', 'revisions')
  );

  register_post_type('mt_sidebar',$args);
}
add_action('init', 'madza_sidebar');





/*-----------------------------------------------------------------------------------*/
/*	PORTFOLIO Custom Post ----------------------------------------------------------*/
/*---------------------------------------------------------------------------------*/

function my_custom_init() {
global $mt_cpt_portfolio;
  $labels = array(
    'name' => esc_html_x('Portfolio', 'post type general name', 'madza_builder69'),
    'singular_name' => esc_html_x('Portfolio', 'post type singular name', 'madza_builder69'),
    'add_new' => esc_html_x('Add Item', 'Event Item', 'madza_builder69'),
    'add_new_item' => esc_html__('Add New Item', 'madza_builder69'),
    'edit_item' => esc_html__('Edit Item', 'madza_builder69'),
    'new_item' => esc_html__('New Item', 'madza_builder69'),
    'view_item' => esc_html__('View Item Details', 'madza_builder69'),
    'search_items' => esc_html__('Search Portfolio Items', 'madza_builder69'),
    'not_found' =>  esc_html__('No portfolio items were found with that criteria', 'madza_builder69'),
    'not_found_in_trash' => esc_html__('No portfolio items found in the Trash with that criteria', 'madza_builder69'),
    'view' =>  esc_html__('View Item', 'madza_builder69')   
  );

  $args = array(
    'labels' => $labels,
    'label' => esc_html__('Portfolio', 'madza_builder69'),
    'singular_label' => esc_html__('Portfolio', 'madza_builder69'),
    'public' => true,
    'show_ui' => true,
    '_builtin' => false,
    'capability_type' => 'page',
    'hierarchical' => true,
    'rewrite' => array('slug' => $mt_cpt_portfolio),
    'menu_position' => 30,
    'menu_icon' => get_template_directory_uri().'/images/application_gallery_view_icon.png',
    'supports' => array('title', 'editor','thumbnail', 'revisions'),
  );

  register_post_type('portfolio',$args);


$labels = array(
  'name' => esc_html__('Categories', 'madza_builder69'),
  'singular_name' => esc_html__('Categories', 'madza_builder69'),
  'search_items' =>  esc_html__('Search', 'madza_builder69'),
  'popular_items' => esc_html__('Popular things', 'madza_builder69'),
  'all_items' => esc_html__( 'Everything' , 'madza_builder69'),
  'parent_item' => esc_html__( 'Parent Categories', 'madza_builder69' ),
  'parent_item_colon' => esc_html__( 'Parent Categories:' , 'madza_builder69'),
  'edit_item' => esc_html__( 'Edit' , 'madza_builder69'),
  'update_item' => esc_html__( 'Update' , 'madza_builder69'),
  'add_new_item' => esc_html__( 'Add New' , 'madza_builder69'),
  'new_item_name' => esc_html__( 'New Name' , 'madza_builder69')
);
	
register_taxonomy('portfolio_cat', array('portfolio'),
	array(
	'hierarchical' => true,
	'labels' => $labels,
	'show_ui' => true,
	'query_var' => true,
	'rewrite' => array('slug' => 'portfolio_categories')
));

}
add_action('init', 'my_custom_init');


add_action( 'admin_init', 'custom_meta_boxes4' );

function custom_meta_boxes4() {

  $my_meta_box4 = array(
    'id'        => 'my_meta_box_4',
    'title'     => 'Portfolio Options',
    'desc'      => '',
    'pages' => array('portfolio'),
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
	   
         array(
        'id'          => 'mb_portfolio_gallery',
        'label'       => 'Gallery',
        'desc'        => '',
        'std'         => '',
        'type'        => 'gallery',
        'section'     => 'general',
        'class'       => '',
        'choices'     => array()
        ),
     array(
        'id'          => 'mt_portfolio_excerpt',
        'label'       => 'Short Description',
        'desc'        => '',
        'std'         => '',
        'type'        => 'text',
        'class'       => '',
        'choices'     => array()
         ),
         array(
        'id'          => 'mt_metabox_client',
        'label'       => 'Client',
        'desc'        => '',
        'std'         => '',
        'type'        => 'text',
        'class'       => '',
        'choices'     => array()
         ),
         array(
        'id'          => 'mt_metabox_date',
        'label'       => 'Date',
        'desc'        => '',
        'std'         => '',
        'type'        => 'text',
        'class'       => '',
        'choices'     => array()
         ),
         array(
        'id'          => 'mt_metabox_location',
        'label'       => 'Location',
        'desc'        => '',
        'std'         => '',
        'type'        => 'text',
        'class'       => '',
        'choices'     => array()
         ),
     
		
      
        array(
        'id'          => 'mb_portfolio_fields',
        'label'       => 'Portfolio Fields',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'general',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'metabox_name',
            'label'   => 'Field Name',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'metabox_text',
            'label'   => 'Field Text',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'metabox_url',
            'label'   => 'Field URL',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'metabox_icon',
            'label'   => 'Field Icon',
            'desc'    => 'Use icons from <a target="_blank" href="http://fortawesome.github.io/Font-Awesome/icons/">FontAwesome</a>',
            'std'     => 'angle-right',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          )
        )
        ),
        array(
        'id'          => 'mb_portfolio_fields_button',
        'label'       => 'Download Buttons',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'general',
        'class'       => '',
        'choices'     => array(),
        'settings'    => array(
          
          array(
            'id'      => 'metabox_button_text',
            'label'   => 'Button Name',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'metabox_button_url',
            'label'   => 'Button URL',
            'desc'    => '',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'metabox_button_icon',
            'label'   => 'Field Icon',
            'desc'    => 'Use icons from <a target="_blank" href="http://fortawesome.github.io/Font-Awesome/icons/">FontAwesome</a>',
            'std'     => 'fa-file-pdf-o',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          )
        )
        ),
         array(
        'id'          => 'mt_client_says',
        'label'       => 'Our Client Says',
        'desc'        => '',
        'std'         => '',
        'type'        => 'text',
        'class'       => '',
        'choices'     => array()
         ),
          array(
        'id'          => 'mt_client_says_name',
        'label'       => 'Long Client Name',
        'desc'        => '',
        'std'         => '',
        'type'        => 'text',
        'class'       => '',
        'choices'     => array()
         ),
         array(
            'id'      => 'mt_client_photo',
            'label'   => 'Client Photo',
            'desc'    => '',
            'std'     => '',
            'type'    => 'upload',
            'class'   => '',
            'choices' => array()
          ),
           array(
        'id'          => 'mt_project_layout',
        'label'       => 'Layouts',
        'desc'        => '',
        'std'         => '1',
        'type'        => 'radio-image',
       
        'class'       => '',
        'choices'     => array(
        						array(
							        'value'   => '1',
							        'label'   => '1',
							        'src'     => get_template_directory_uri().'/images/layout_a.png'
							      ),
							      array(
							        'value'   => '4',
							        'label'   => '7',
							        'src'     => get_template_directory_uri().'/images/layout_d.png'
							      )   ,
							      array(
							        'value'   => '2',
							        'label'   => '2',
							        'src'     => get_template_directory_uri().'/images/layout_b.png'
							      ),
							      array(
							        'value'   => '3',
							        'label'   => '7',
							        'src'     => get_template_directory_uri().'/images/layout_c.png'
							      )  
							      
							  )
		),
        array(
        'id'          => 'mb_page_sections_in',
        'label'       => 'Page Sections',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'section',
            'label'   => 'Page Section',
            'desc'    => '',
            'std'     => '',
            'type'        => 'custom-post-type-select',
            'post_type'   => 'mt_section',
            'class'   => '',
            'choices' => array()
          )
        )
        )

)
    
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $my_meta_box4 ); }

}





/*-----------------------------------------------------------------------------------*/
/*	ALL OTHER METABOX  -------------------------------------------------------------*/
/*---------------------------------------------------------------------------------*/



function filter_radio_images( $array, $field_id ) {
  
  /* only run the filter where the field ID is my_radio_images */
  if ( $field_id == 'my_radio_images' ) {
    $array = array(
      array(
        'value'   => 'left-sidebar',
        'label'   => esc_html__( 'Left Sidebar', 'madza_builder69' ),
        'src'     => OT_URL . '/assets/images/layout/left-sidebar.png'
      ),
      array(
        'value'   => 'right-sidebar',
        'label'   => esc_html__( 'Right Sidebar', 'madza_builder69' ),
        'src'     => OT_URL . '/assets/images/layout/right-sidebar.png'
      )
    );
  }
  
  return $array;
  
}


add_filter( 'ot_radio_images', 'filter_radio_images', 10, 2 );



add_action( 'admin_init', 'custom_meta_boxes_sta' );

function custom_meta_boxes_sta() {

  $my_meta_box_sta = array(
    'id'        => 'my_meta_box_sta',
    'title'     => 'Post Options',
    'desc'      => '',
    'pages' => 'post',
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
	           
		array(
        'id'          => 'mt_portfolio_slider_heightstan',
        'label'       => 'Image Height (px)',
        'desc'        => '',
        'std'         => '200',
        'type'        => 'text',
        'class'       => '',
        'choices'     => array()
          )
        
     )
    
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $my_meta_box_sta ); }

}


add_action( 'admin_init', 'custom_meta_boxes_video' );

function custom_meta_boxes_video() {

  $my_meta_box_video = array(
    'id'        => 'my_meta_box_video',
    'title'     => 'Video Post Options',
    'desc'      => '',
    'pages' => 'post',
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
	           
		array(
        'id'          => 'mt_post_video_embed',
        'label'       => 'Video Embed Code',
        'desc'        => '',
        'std'         => '',
        'type'        => 'textarea',
        'class'       => '',
        'choices'     => array()
          )
        
     )
    
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $my_meta_box_video ); }

}
add_action( 'admin_init', 'custom_meta_boxes_audio' );


function custom_meta_boxes_audio() {

  $my_meta_box_audio = array(
    'id'        => 'my_meta_box_audio',
    'title'     => 'Audio Post Options',
    'desc'      => '',
    'pages' => 'post',
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
	           
		array(
        'id'          => 'mt_post_audio_embed',
        'label'       => 'Audio Embed Code',
        'desc'        => '',
        'std'         => '',
        'type'        => 'textarea',
        'class'       => '',
        'choices'     => array()
          )
        
     )
    
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $my_meta_box_audio ); }

}


add_action( 'admin_init', 'custom_meta_boxes_image' );

function custom_meta_boxes_image() {

  $my_meta_box_image = array(
    'id'        => 'my_meta_box_image',
    'title'     => 'Post Options',
    'desc'      => '',
    'pages' => 'post',
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
	    
          array(
        'id'          => 'postm_title_on',
        'label'       => 'Post Title',
        'desc'        => '',
        'std'         => 'off',
        'type'        => 'select',
        'class'       => '',
        'choices'     => array( 
        array(
        'value'   => 'on',
        'label'   => esc_html__( 'On', 'madza_builder69' )
      ),
      array(
        'value'   => 'off',
        'label'   => esc_html__( 'Off', 'madza_builder69' )
      ))
      ),
         array(
        'id'          => 'postm_border_on',
        'label'       => 'Post Bottom Border',
        'desc'        => '',
        'std'         => 'on',
        'type'        => 'select',
        'class'       => '',
        'choices'     => array( 
        array(
        'value'   => 'on',
        'label'   => esc_html__( 'On', 'madza_builder69' )
      ),
      array(
        'value'   => 'off',
        'label'   => esc_html__( 'Off', 'madza_builder69' )
      ))
      ),)
    
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $my_meta_box_image ); }

}





add_action( 'admin_init', 'custom_meta_boxes_quo' );

function custom_meta_boxes_quo() {

  $my_meta_box_quo = array(
    'id'        => 'my_meta_box_quo',
    'title'     => 'Post Options',
    'desc'      => '',
    'pages' => 'post',
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
	           
		array(
        'id'          => 'mt_portfolio_format_quo_url',
        'label'       => 'Link URL',
        'desc'        => '',
        'type'        => 'text',
        'class'       => '',
        'choices'     => array()
          )
        
)
    
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $my_meta_box_quo ); }

}




add_action( 'admin_init', 'custom_meta_boxes_links' );

function custom_meta_boxes_links() {

  $my_meta_box_links = array(
    'id'        => 'my_meta_box_links',
    'title'     => 'Post Options',
    'desc'      => '',
    'pages' => 'post',
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
	           
		array(
        'id'          => 'mt_portfolio_format_link_url',
        'label'       => 'Link URL',
        'desc'        => '',
        'type'        => 'text',
        'class'       => '',
        'choices'     => array()
          )
        
)
    
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $my_meta_box_links ); }

}


add_action( 'admin_init', 'custom_meta_boxes9' );

function custom_meta_boxes9() {

  $my_meta_box9 = array(
    'id'        => 'my_meta_box_9',
    'title'     => 'Post Options',
    'desc'      => '',
    'pages' => 'post',
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
	           
		array(
        'id'          => 'mt_portfolio_slider_height2',
        'label'       => 'Slider Height (px)',
        'desc'        => 'Default size is unlimited',
        'std'         => '',
        'type'        => 'text',
        'class'       => '',
        'choices'     => array()
          )
        ,
        
      array(
        'id'          => 'mb_portfolio_slider',
        'label'       => 'Slider Media',
        'desc'        => '',
        'std'         => '',
        'type'        => 'gallery',
        'section'     => 'general',
        'class'       => 'mt_meta_image',
        'choices'     => array()
        )
)
    
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $my_meta_box9 ); }

}



add_action( 'admin_init', 'custom_meta_boxes2' );

function custom_meta_boxes2() {

  $my_meta_box2 = array(
    'id'        => 'custom_meta_boxes2',
    'title'     => 'Page Options',
    'desc'      => '',
    'pages'     => array('page', 'causes'),
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
      array(
            'id'      => 'mt_slider_shortcude',
            'label'   => 'Header Slider Shortcode',
            'desc'    => 'Sample: [rev_slider homepage]',
            'section'     => 'style_options',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
      array(
        'id'          => 'layout_positions',
        'label'       => 'Layouts',
        'desc'        => '',
        'std'         => 'full',
        'type'        => 'radio-image',
       
        'class'       => '',
        'choices'     => array(
        						array(
							        'value'   => 'right',
							        'label'   => '1',
							        'src'     => get_template_directory_uri().'/images/layout_2.jpg'
							      ),
							      array(
							        'value'   => 'left',
							        'label'   => '2',
							        'src'     => get_template_directory_uri().'/images/layout_1.jpg'
							      ),
							      array(
							        'value'   => 'full',
							        'label'   => '3',
							        'src'     => get_template_directory_uri().'/images/layout_3.jpg'
							      )   
							      
							  )
							  
      ),
       array(
        'id'          => 'layout_sidebar',
        'label'       => 'Sidebar',
        'desc'        => '',
        'std'         => '',
        'post_type'   => 'mt_sidebar',
        'type'        => 'sidebar-select',
        'class'       => '',
        'choices'     => array(
					        array(
					        'value'   => 'sidebar_off',
					        'label'   => esc_html__( 'Sidebar Off', 'madza_builder69' )
					      )
        )
      ),
      array(
        'id'          => 'mb_page_sections_in',
        'label'       => 'Page Sections',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'section',
            'label'   => 'Page Section',
            'desc'    => '',
            'std'     => '',
            'type'        => 'custom-post-type-select',
            'post_type'   => 'mt_section',
            'class'   => '',
            'choices' => array()
          )
        )
        ),
        array(
		        'id'          => 'mt_paddings_on',
		        'label'       => 'Show page top&bottom paddings',
		        'desc'        => '',
		        'std'         => 'yes',
		        'type'        => 'select',
		        'class'       => '',
		        'choices'     => array( 
				        array(
				        'value'   => 'no',
				        'label'   => esc_html__( 'Off', 'madza_builder69' )
				      ),
				      array(
				        'value'   => 'yes',
				        'label'   => esc_html__( 'On', 'madza_builder69' )
				      ))
	      ),
    )
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $my_meta_box2 ); }

}


add_action( 'admin_init', 'custom_meta_boxes22' );

function custom_meta_boxes22() {

  $my_meta_box22 = array(
    'id'        => 'custom_meta_boxes2',
    'title'     => 'Page Options',
    'desc'      => '',
    'pages'     => array( 'post'),
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
     
      array(
        'id'          => 'layout_positions',
        'label'       => 'Layouts',
        'desc'        => '',
        'std'         => 'right',
        'type'        => 'radio-image',
       
        'class'       => '',
        'choices'     => array(
        						array(
							        'value'   => 'right',
							        'label'   => '1',
							        'src'     => get_template_directory_uri().'/images/layout_2.jpg'
							      ),
							      array(
							        'value'   => 'left',
							        'label'   => '2',
							        'src'     => get_template_directory_uri().'/images/layout_1.jpg'
							      ),
							      array(
							        'value'   => 'full',
							        'label'   => '3',
							        'src'     => get_template_directory_uri().'/images/layout_3.jpg'
							      )   
							      
							  )
							  
      ),
       array(
        'id'          => 'layout_sidebar',
        'label'       => 'Sidebar',
        'desc'        => '',
        'std'         => '',
        'post_type'   => 'mt_sidebar',
        'type'        => 'sidebar-select',
        'class'       => '',
        'choices'     => array(
					        array(
					        'value'   => 'sidebar_off',
					        'label'   => esc_html__( 'Sidebar Off', 'madza_builder69' )
					      )
        )
      ),
      array(
        'id'          => 'mb_page_sections_in',
        'label'       => 'Page Sections',
        'desc'        => '',
        'std'         => '',
        'type'        => 'list-item',
        'choices'     => array(),
        'settings'    => array(
          array(
            'id'      => 'section',
            'label'   => 'Page Section',
            'desc'    => '',
            'std'     => '',
            'type'        => 'custom-post-type-select',
            'post_type'   => 'mt_section',
            'class'   => '',
            'choices' => array()
          )
        )
        ),
        array(
		        'id'          => 'mt_paddings_on',
		        'label'       => 'Show page top&bottom paddings',
		        'desc'        => '',
		        'std'         => 'yes',
		        'type'        => 'select',
		        'class'       => '',
		        'choices'     => array( 
				        array(
				        'value'   => 'no',
				        'label'   => esc_html__( 'Off', 'madza_builder69' )
				      ),
				      array(
				        'value'   => 'yes',
				        'label'   => esc_html__( 'On', 'madza_builder69' )
				      ))
	      ),
	      
    )
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $my_meta_box22 ); }

}



add_action( 'admin_init', 'custom_meta_boxes1' );

function custom_meta_boxes1() {
global $patterns;
  $my_meta_box = array(
    'id'        => 'my_meta_box_1',
    'title'     => 'Style Options',
    'desc'      => '',
    'pages'     => array( 'post', 'page', 'portfolio', 'causes', 'our-services', 'our-staff','events'),
    'context'   => 'normal',
    'priority'  => 'high',
    'fields'    => array(
	    
	 array(
        'id'          => 'm_title_on',
        'label'       => 'Page Title',
        'desc'        => '',
        'std'         => 'on',
        'type'        => 'select',
        'class'       => '',
        'choices'     => array( 
       array(
        'value'   => 'on',
        'label'   => esc_html__( 'On', 'madza_builder69' )
      ),
      array(
        'value'   => 'off',
        'label'   => esc_html__( 'Off', 'madza_builder69' )
      ))
      ),

	    array(
            'id'      => 'mt_subtitle',
            'label'   => 'Sub Title',
            'desc'    => '',
            'section'     => 'style_options',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
          array(
            'id'      => 'mt_uptitle',
            'label'   => 'Up Title',
            'desc'    => '',
            'section'     => 'style_options',
            'std'     => '',
            'type'    => 'text',
            'class'   => '',
            'choices' => array()
          ),
    
    array(
        'id'          => 'mt_colors_page_2',
        'label'       => 'Page Colors',
        'desc'        => '',
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'style_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'mt_layout_styler_page',
        'label'       => 'Page Layout Style',
        'std'         => '',
        'type'        => 'select',
        'section'     => 'style_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array( 
          array(
            'value'       => '',
            'label'       => 'Default',
            'src'         => ''
          ),
          array(
            'value'       => 'border',
            'label'       => 'Border Layout',
            'src'         => ''
          ), 
          array(
            'value'       => 'full',
            'label'       => 'Full Width Layout',
            'src'         => ''
          )        
         ),
      ),
      array(
        'id'          => 'm_page_background',
        'label'       => 'Page Background',
        'desc'        => '',
        'std'         => '',
        'type'        => 'background',
        'class'       => '',
        'choices'     => array()
      ),
      array(
        'id'          => 'm_content_background',
        'label'       => 'Content Background',
        'desc'        => '',
        'std'         => '',
        'type'        => 'background',
        'class'       => '',
        'choices'     => array()
      ), 
      array(
	        'id'          => 'mt_page_page_color_bg_patterns',
	        'label'       => 'Page Background Patterns',
	        'desc'        => '',
	        'std'         => 'off',
	        'type'        => 'radio-image',
			'class'       => 'mt-patterns',
	        'choices'     =>  $patterns
								  
	  ),   

      array(
        'id'          => 'm_title_backgrounds',
        'label'       => 'Page Title Background',
        'desc'        => '',
        'std'         => '',
        'type'        => 'background',
        'class'       => '',
        'choices'     => array()
      ),
      
      array(
	        'id'          => 'mt_page_title_color_bg_patterns',
	        'label'       => 'Title Background Patterns',
	        'desc'        => '',
	        'std'         => 'off',
	        'type'        => 'radio-image',
			'class'       => 'mt-patterns',
	        'choices'     =>  $patterns
								  
	 ),
	       array(
        'id'          => 'm_title_contrast',
        'label'       => 'Title Contrast',
        'desc'        => '',
        'std'         => 'on',
        'type'        => 'select',
        'class'       => '',
        'choices'     => array(
        array(
        'value'   => 'default',
        'label'   => esc_html__( 'Default', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_light2',
        'label'   => esc_html__( 'Light', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_dark2',
        'label'   => esc_html__( 'Dark', 'madza_builder69' )
      ))

    ),
    
         array(
        'id'          => 'm_title_style',
        'label'       => 'Title Style',
        'desc'        => '',
        'std'         => 'on',
        'type'        => 'select',
        'class'       => '',
        'choices'     => array(
        array(
        'value'   => 'default',
        'label'   => esc_html__( 'Default', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_style_1',
        'label'   => esc_html__( 'Style 1', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_style_2',
        'label'   => esc_html__( 'Style 2', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_style_3',
        'label'   => esc_html__( 'Style 3', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_style_4',
        'label'   => esc_html__( 'Style 4', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_style_5',
        'label'   => esc_html__( 'Style 5', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_style_6',
        'label'   => esc_html__( 'Style 6', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_style_7',
        'label'   => esc_html__( 'Style 7', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_style_8',
        'label'   => esc_html__( 'Style 8', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_style_9',
        'label'   => esc_html__( 'Style 9', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_style_10',
        'label'   => esc_html__( 'Style 10', 'madza_builder69' )
      ),
      array(
        'value'   => 'mt_title_style_11',
        'label'   => esc_html__( 'Style 11', 'madza_builder69' )
      ))

    ),

      
      array(
        'id'          => 'm_title_bred',
        'label'       => 'Page Breadcrumb',
        'desc'        => '',
        'std'         => 'on',
        'type'        => 'select',
        'class'       => '',
        'choices'     => array(
        array(
        'value'   => 'on',
        'label'   => esc_html__( 'On', 'madza_builder69' )
      ),
      array(
        'value'   => 'off',
        'label'   => esc_html__( 'Off', 'madza_builder69' )
      ))

    ),
        
        
      
      
    
    
    )
  );
  
  if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $my_meta_box ); }

}




/*-----------------------------------------------------------------------------------*/
/*	Sidebar Custom Post
/*-----------------------------------------------------------------------------------*/


add_action( 'admin_init', 'mt_template' );

function mt_template() {

  $mt_template = array(
    'id'        => 'mt_template',
    'title'     => 'Template Options',
    'desc'      => '',
    'pages'     => array('page'),
    'context'   => 'normal',
    'priority'  => 'default',
    'fields'    => array(
    		
    		array(
            'id'      => 'mt_template_item_pp',
            'label'   => 'Items per page',
            'std'     => '0',
            'type'        => 'numeric_slider',
			'min_max_step'=> '0,100,1',
            'class'   => '',
            'choices' => array()
            ),
            
            array(
            'id'          => 'mt_blog_category',
            'label'       => 'Category for Blog template',
            'std'         => '',
            'type'        => 'taxonomy-select',
            'rows'        => '',
            'post_type'   => 'post',
            'taxonomy'    => 'category',
            'class'       => ''
            ),
            
            array(
            'id'          => 'mt_portfolio_category',
            'label'       => 'Category for Portfolio template',
            'std'         => '',
            'type'        => 'taxonomy-select',
            'rows'        => '',
            'post_type'   => 'portfolio',
            'taxonomy'    => 'portfolio_cat',
            'class'       => ''
            ),
          
    		array(
	        'id'          => 'mt_template_columns',
	        'label'       => 'Columns for Portfolio template',
	        'std'         => '',
	        'type'        => 'select',
	        'rows'        => '',
	        'post_type'   => '',
	        'taxonomy'    => '',
	        'class'       => '',
	        'choices'     => array( 
	          array(
	            'value'       => '4',
	            'label'       => '4 Columns',
	            'src'         => ''
	          ),
	          array(
	            'value'       => '3',
	            'label'       => '3 Columns',
	            'src'         => ''
	          ),
	          array(
	            'value'       => '2',
	            'label'       => '2 Columns',
	            'src'         => ''
	          ),
	          array(
	            'value'       => '1',
	            'label'       => '1 Columns',
	            'src'         => ''
	          )     
	         )
	      ),
	      array(
	        'id'          => 'mt_template_links',
	        'label'       => 'Link type for Portfolio template',
	        'std'         => '',
	        'type'        => 'select',
	        'rows'        => '',
	        'post_type'   => '',
	        'taxonomy'    => '',
	        'class'       => '',
	        'choices'     => array( 
	          array(
	            'value'       => 'permalink',
	            'label'       => 'Permalink',
	            'src'         => ''
	          ),
	          array(
	            'value'       => 'lightbox',
	            'label'       => 'Lightbox',
	            'src'         => ''
	          )     
	         )
	      ),
	      array(
	        'id'          => 'mt_template_menu',
	        'label'       => 'Menu type for Portfolio template',
	        'std'         => '',
	        'type'        => 'select',
	        'rows'        => '',
	        'post_type'   => '',
	        'taxonomy'    => '',
	        'class'       => '',
	        'choices'     => array( 
	          array(
	            'value'       => 'sorting',
	            'label'       => 'Sorting',
	            'src'         => ''
	          ),
	          array(
	            'value'       => 'none',
	            'label'       => 'none',
	            'src'         => ''
	          )     
	         )
	      )
      )

    );
  
 if (  class_exists( 'OT_Loader' ) ) { ot_register_meta_box( $mt_template ); }

}


?>